<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    exclude-result-prefixes="fo"
    version="1.1"
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:java="http://xml.apache.org/xslt/java"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:variable
        name="configDoc"
        select="document(bidInvRoot/@config)" />

    <xsl:variable name="ReportName">
        Projektausschreibung
    </xsl:variable>

    <xsl:include href="Header.xsl" />

    <xsl:template match="bidInvRoot">
        <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
            <fo:layout-master-set>
                <fo:simple-page-master
                    margin-bottom="1.5cm"
                    margin-left="1cm"
                    margin-right="1cm"
                    margin-top="2cm"
                    master-name="simpleA4"
                    page-height="29.7cm"
                    page-width="21cm">
                    <fo:region-body
                        margin-bottom="1cm"
                        margin-top="5cm" />
                    <fo:region-before
                        extent="5cm"
                        margin-left="2cm" />
                    <fo:region-after extent="1cm" />
                </fo:simple-page-master>
            </fo:layout-master-set>
            <fo:page-sequence master-reference="simpleA4">
                <xsl:call-template name="header">
                    <xsl:with-param
                        name="projectName"
                        select="@name" />
                </xsl:call-template>
                <xsl:call-template name="footnote" />
                <fo:flow
                    flow-name="xsl-region-body"
                    force-page-count="auto">
                    <fo:block>
                        <fo:table
                            table-layout="fixed"
                            width="100%"
                            border="1pt solid">
                            <fo:table-column column-width="16%" />
                            <fo:table-column column-width="55%" />
                            <fo:table-column column-width="8%" />
                            <fo:table-column column-width="8%" />
                            <fo:table-column column-width="13%" />

                            <fo:table-header>
                                <fo:table-row>
                                    <fo:table-cell
                                        border="1pt"
                                        border-style="solid">
                                        <fo:block
                                            margin="1mm"
                                            font-size="9pt">
                                            LV-Pos.Nr.
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell
                                        border="1pt"
                                        border-style="solid">
                                        <fo:block
                                            margin="1mm"
                                            font-size="9pt">
                                            Beschreibung der Leistung
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell
                                        border="1pt"
                                        border-style="solid">
                                        <fo:block
                                            margin="1mm"
                                            font-size="9pt">
                                            Menge
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell
                                        border="1pt"
                                        border-style="solid">
                                        <fo:block
                                            margin="1mm"
                                            font-size="9pt">
                                            Preis/EP
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell
                                        border="1pt"
                                        border-style="solid">
                                        <fo:block
                                            margin="1mm"
                                            font-size="9pt">
                                            Preis/Gesamt
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-header>

                            <fo:table-body>
                                <xsl:apply-templates select="preface" />
                                <xsl:apply-templates select="bidInvGeneral">
                                    <xsl:sort
                                        select="@position"
                                        data-type="number" />
                                </xsl:apply-templates>
                            </fo:table-body>
                        </fo:table>
                    </fo:block>
                    <xsl:call-template name="terminator" />
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>

    <xsl:template match="preface">
        <fo:table-row>
            <fo:table-cell
                border="1pt"
                border-style="solid">
                <fo:block
                    font-size="10pt"
                    margin="1mm">
                    <xsl:value-of select="@lvs" />
                </fo:block>
            </fo:table-cell>
            <fo:table-cell
                text-align="start"
                border="1pt"
                border-style="solid">
                <fo:block margin="1mm">
                    <xsl:call-template name="rtf" />
                </fo:block>
            </fo:table-cell>
            <fo:table-cell
                border="1pt"
                border-style="solid">
                <fo:block />
            </fo:table-cell>
            <fo:table-cell
                border="1pt"
                border-style="solid">
                <fo:block />
            </fo:table-cell>
            <fo:table-cell
                border="1pt"
                border-style="solid">
                <fo:block />
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="bidInvGeneral">
        <xsl:apply-templates select="textGeneral" />
        <xsl:apply-templates select="bidInvs">
            <xsl:sort
                select="@lvsort1"
                data-type="number" />
            <xsl:sort
                select="@lvsort2"
                data-type="number" />
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="bidInvs">
        <fo:table-row page-break-inside="avoid">
            <fo:table-cell
                text-align="start"
                border="1pt solid">
                <fo:block
                    font-size="9pt"
                    margin="1mm">
                    <xsl:value-of select="@lvs" />
                </fo:block>
            </fo:table-cell>
            <fo:table-cell
                text-align="start"
                border="1pt solid">
                <fo:block margin="1mm">
                    <xsl:call-template name="rtf" />
                </fo:block>
            </fo:table-cell>
            <fo:table-cell
                text-align="end"
                border="1pt solid">
                <fo:block
                    font-size="9pt"
                    margin="1mm">
                    <xsl:choose>
                        <xsl:when test="@type='tube'">
                            <xsl:value-of select="ceiling(@count)" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="translate(format-number(@count,'0.#'),'.',',')" />
                        </xsl:otherwise>
                    </xsl:choose>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell
                text-align="start"
                margin-left="0.1cm"
                border="1pt"
                border-style="solid">
                <fo:block
                    font-size="9pt"
                    margin="1mm">
                </fo:block>
            </fo:table-cell>
            <fo:table-cell
                border="1pt"
                border-style="solid">
                <fo:block margin="1mm" />
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="textGeneral">
        <fo:table-row page-break-inside="avoid">
            <fo:table-cell
                border="1pt"
                border-style="solid">
                <fo:block
                    font-size="9pt"
                    margin="0.1cm">
                    <xsl:value-of select="@lvs" />
                </fo:block>
            </fo:table-cell>
            <fo:table-cell
                text-align="start"
                border="1pt"
                border-style="solid">
                <fo:block margin="1mm">
                    <xsl:call-template name="rtf" />
                </fo:block>
            </fo:table-cell>
            <fo:table-cell
                border="1pt"
                border-style="solid">
                <fo:block />
            </fo:table-cell>
            <fo:table-cell
                border="1pt"
                border-style="solid">
                <fo:block />
            </fo:table-cell>
            <fo:table-cell
                border="1pt"
                border-style="solid">
                <fo:block />
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

</xsl:stylesheet>