<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    exclude-result-prefixes="fo"
    version="1.1"
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:java="http://xml.apache.org/xslt/java"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template name="rtf">
        <xsl:apply-templates select="section" />
    </xsl:template>

    <xsl:template match="section">
        <xsl:for-each select="paragraph">
            <xsl:choose>
                <xsl:when test="count(following-sibling::paragraph)>0">
                    <fo:block>
                        <xsl:call-template name="paragraph" />
                    </fo:block>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:if test="text()">
                        <xsl:call-template name="paragraph" />
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="paragraph">
        <xsl:apply-templates select="text" />
        <xsl:apply-templates select="empty-text" />
    </xsl:template>

    <xsl:template match="text">
        <fo:inline font-size="9pt">
            <xsl:call-template name="TabReplace">
                <xsl:with-param
                    name="stringIns"
                    select="text()" />
            </xsl:call-template>
        </fo:inline>
    </xsl:template>

    <xsl:template match="empty-text">
        <xsl:if test="count(parent::node()/preceding-sibling::paragraph)>0">
            <fo:block font-size="9pt">&#160;</fo:block>
        </xsl:if>
    </xsl:template>

    <xsl:template name="TabReplace">
        <xsl:param name="stringIns" />
        <!-- Tabstop in Leerzeichen -->
        <xsl:call-template name="SubstringReplace">
            <xsl:with-param
                name="stringIn"
                select="$stringIns" />
        </xsl:call-template>
    </xsl:template>

</xsl:stylesheet>
